//=============================================================================
// TournamentScoreBoard
//=============================================================================
class IA_SB extends TournamentScoreBoard;

#exec TEXTURE IMPORT NAME=IALogo FILE=Textures\IALogo.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=Bottom FILE=Textures\Bottom.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=BottomLeft FILE=Textures\BottomLeft.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=BottomRight FILE=Textures\BottomRight.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=Left FILE=Textures\Left.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=Right FILE=Textures\Right.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=Topp FILE=Textures\Top.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=TopLeft FILE=Textures\TopLeft.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=TopRight FILE=Textures\TopRight.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=AddToDamage FILE=Textures\AddToDamage.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=ReduceDamageTaken FILE=Textures\ReduceDamageTaken.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=AddLightningDamage FILE=Textures\AddLightningDamage.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=RegainHealth FILE=Textures\RegainHealth.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=AddFireDamage FILE=Textures\AddFireDamage.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=AddPoisonDamage FILE=Textures\AddPoisonDamage.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=AddColdDamage FILE=Textures\AddColdDamage.bmp Group=ScoreBoard MIPS=ON
#exec TEXTURE IMPORT NAME=RegainAmmo FILE=Textures\RegainAmmo.bmp Group=ScoreBoard MIPS=ON

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor,WallPaperColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

//replicated Variables used to show on the SB:
var int ShowLevel,
	ShowHealthRegain,
	ShowAmmoRegain,
	ShowReducedDamage,
	ShowAddToDamage,
	ShowHealthStolen,
	ShowMaximumHealth,
	ShowAmmoStolen,
	ShowArmorStolen;

//This function finds the correct variables to show on SB
function GrabPlayerVars()
{

}


function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
local float X,Y;

	X = Canvas.ClipX;
	Y = Canvas.ClipY;

	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 8);
	Canvas.DrawTile(Texture'IALogo', 512, 128, 0, 0, 512, 128);
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);

	Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawCategoryHeaders(Canvas Canvas)
{
	GrabPlayerVars();
	DrawPlayerName(Canvas);
	DrawPlayerPing(Canvas);
	DrawStats(Canvas);
	DrawScoreAndLevel(Canvas);
}

function DrawScoreAndLevel(Canvas Canvas)
{
local float X,Y,XL,YL;

	X = Canvas.ClipX * 0.5;
	Y = 420;

	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X - 264, Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y - 8);
	Canvas.DrawTile(Texture'Topp', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 259, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect3.fireeffect3', 518, 38, 0, 0, 518, 38);

	Canvas.Style = Style;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.StrLen("Score: "@int(PlayerPawn(Owner).PlayerReplicationInfo.Score)$" - Level: 1", XL, YL );
	Canvas.SetPos(X - XL * 0.5, Y + 4);
	Canvas.DrawColor = GoldColor;
	Canvas.DrawText("Score: "@int(PlayerPawn(Owner).PlayerReplicationInfo.Score)$" - Level: "@ShowLevel, False);
}

function DrawStats(Canvas Canvas)
{
local float X,Y,XL,YL;

	//Draw Damage Done (AddToDamage variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y = 212;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddToDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Damage Done", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Damage Done", false );
	Canvas.StrLen(ShowAddToDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowAddToDamage$"%", false );

	//Draw Health Regain (RegainHealth variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'RegainHealth', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Health Regain Rate", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Health Regain Rate", false );
	Canvas.StrLen(ShowHealthRegain$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowHealthRegain$"%", false );

	//Draw Regain Ammo (RegainAmmo variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y += 52;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'RegainAmmo', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Regain Ammo Rate", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Regain Ammo Rate", false );
	Canvas.StrLen(ShowAmmoRegain$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowAmmoRegain$"%", false );

	//Draw Reduce Damage (ReduceDamage variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'ReduceDamageTaken', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Reduce Damage Taken", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Reduce Damage Taken", false );
	Canvas.StrLen(ShowReducedDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowReducedDamage$"%", false );

	//Draw Fire Damage (AddFireDamage variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y += 52;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddFireDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Health Stolen", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Health Stolen", false );
	Canvas.StrLen(ShowHealthStolen$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowHealthStolen$"%", false );

	//Draw Lightning Damage (AddLightningDamage variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddLightningDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Maximum Health", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Maximum Health", false );
	Canvas.StrLen(ShowMaximumHealth$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowMaximumHealth$"%", false );

	//Draw Poison Damage (AddPoisonDamage variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y += 52;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddPoisonDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Ammo Stolen", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Ammo Stolen", false );
	Canvas.StrLen(ShowAmmoStolen$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowAmmoStolen$"%", false );

	//Draw Cold Damage (AddColdDamage variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddColdDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Armor Stolen", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Armor Stolen", false );
	Canvas.StrLen(ShowArmorStolen$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowArmorStolen$"%", false );
}

function DrawPlayerPing(Canvas Canvas)
{
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(CanVas.ClipX * 0.5 + 266, 161);
	Canvas.DrawTile(Texture'DisconnectWarn', 32, 32, 0, 0, 64, 64);
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);

	if (PlayerPawn(Owner).PlayerReplicationInfo.Ping < 100)
		Canvas.DrawColor = GreenColor;
	else if (PlayerPawn(Owner).PlayerReplicationInfo.Ping < 250)
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = RedColor;

	Canvas.SetPos(CanVas.ClipX * 0.5 + 300, 169);
	Canvas.DrawText(PlayerPawn(Owner).PlayerReplicationInfo.Ping, false );
}

function DrawPlayerName(Canvas Canvas)
{
local float X,Y,XL,YL;

	X = Canvas.ClipX * 0.5;
	Y = 160;

	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X - 264, Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y - 8);
	Canvas.DrawTile(Texture'Topp', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 259, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect3.fireeffect3', 518, 38, 0, 0, 518, 38);

	Canvas.Style = Style;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.StrLen(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName, XL, YL );
	Canvas.SetPos(X - XL * 0.5, Y + 4);
	Canvas.DrawColor = GoldColor;
	Canvas.DrawText(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName, False);
}


function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, XL3, YL3;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	// Draw Name

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.1875, YOffset);
	Canvas.DrawText(PlayerOwner.PlayerReplicationInfo.PlayerName, False);

	Canvas.StrLen( "0000", XL, YL );

	// Draw Score
	
	Canvas.StrLen( int(PlayerOwner.PlayerReplicationInfo.Score), XL2, YL );
	Canvas.SetPos( Canvas.ClipX * 0.625 + XL * 0.5 - XL2, YOffset );
	Canvas.DrawText( int(PlayerOwner.PlayerReplicationInfo.Score), false );

	// Draw Deaths
	Canvas.StrLen( int(PlayerOwner.PlayerReplicationInfo.Deaths), XL2, YL );
	Canvas.SetPos( Canvas.ClipX * 0.75 + XL * 0.5 - XL2, YOffset );
	Canvas.DrawText( int(PlayerOwner.PlayerReplicationInfo.Deaths), false );

	if (Canvas.ClipX > 512)
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);

		// Draw Time
		Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
		Canvas.TextSize( TimeString$": 999", XL3, YL3 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset );
		Canvas.DrawText( TimeString$":"@Time, false );

		// Draw FPH
		Canvas.TextSize( FPHString$": 999", XL2, YL2 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset + 0.5 * YL );
		Canvas.DrawText( FPHString$": "@int(60 * PlayerOwner.PlayerReplicationInfo.Score/Time), false );

		XL3 = FMax(XL3, XL2);
		// Draw Ping
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL + XL3 + 16, YOffset );
		Canvas.DrawText( PingString$":"@PlayerOwner.PlayerReplicationInfo.Ping, false );
		}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	DrawCategoryHeaders(Canvas);

	Canvas.StrLen( "TEST", XL, YL );
	YStart = Canvas.CurY;
	YOffset = YStart;

	Canvas.SetPos(0, 0);
	YOffset = YStart + I * YL;
	//DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Score"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     WallPaperColor=(R=64,G=64,B=64)
}
